const router = require("express").Router();
const { getTotalCostAmount } = require("../controllers/costController");
const { loadUser } = require("../controllers/generalController");
const {
  createSales,
  getAllSales,
  getSalesByUser,
  totalSalesForSelectedDay,
  getMyDailySalesByDate,
  getSalesForaParticulardate,
  getSalesChartInfo,
  adminGetUserDailySalesByDate,
  getSalesByUserLimit,
  salesReturns,
  deleteProductInSales,
  getAllSalesProductsWithReasons,
  getAllCustomers,
  getSalesReturnsDataByDate,
  updateSalesDate,
  getProductsAllSales,
  adminGetProductSalesStatistics,
  getAllGrandTotalSalesForYear,
  getProductYearlySalesStatistics,
  getCreditSalesGrandTotalSalesForYear,
  downloadSales,
  getSalesAnalyticsByYearMonth,
  getTopProductsByQuantity,
  getTopProductsByAmount,
  getTopProducts,
} = require("../controllers/selesController");

const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/sales")
  .post(verifyToken, loadUser, createSales)
  .get(verifyToken, loadUser, getAllSales);
router
  .route("/sales/products/:productId")
  .get(verifyToken, loadUser, getProductsAllSales);

router
  .route("/sales/update-sales/:productId")
  .put(verifyToken, loadUser, salesReturns);
router.route("/my/sales").get(verifyToken, loadUser, getSalesByUser);
router
  .route("/sales/return/report")
  .get(verifyToken, loadUser, getAllSalesProductsWithReasons);
router
  .route("/sales/:saleId/products/:productId")
  .delete(verifyToken, loadUser, deleteProductInSales);

router
  .route("/sales/totalsalesforseslecteddays")
  .post(verifyToken, loadUser, totalSalesForSelectedDay);
router
  .route("/sales/mydailysales")
  .get(verifyToken, loadUser, getMyDailySalesByDate);
router.route("/sales/limit").get(verifyToken, loadUser, getSalesByUserLimit);

router
  .route("/sales/salesforaparticulardate")
  .get(verifyToken, loadUser, getSalesForaParticulardate);

router.route("/sales/chart").get(verifyToken, loadUser, getSalesChartInfo);

router
  .route("/sales/admingetuserdailysalesbydate")
  .get(verifyToken, loadUser, adminGetUserDailySalesByDate);

router
  .route("/cost/totalcostforseslecteddays")
  .post(verifyToken, getTotalCostAmount);

router
  .route("/sales/customers_report/data")
  .get(verifyToken, loadUser, getAllCustomers);

router
  .route("/sales/returns/:productId")
  .get(verifyToken, loadUser, getSalesReturnsDataByDate);

router
  .route("/update-date/sales/:id")
  .post(verifyToken, loadUser, updateSalesDate);

router
  .route("/sales/product/sales-statistics")
  .get(verifyToken, loadUser, adminGetProductSalesStatistics);
router
  .route("/yearly/sales")
  .get(verifyToken, loadUser, getAllGrandTotalSalesForYear);
router
  .route("/sales/analytics")
  .get(verifyToken, loadUser, getSalesAnalyticsByYearMonth);

router
  .route("/product-sales-statistics")
  .get(verifyToken, loadUser, getProductYearlySalesStatistics);
router
  .route("/credit/sales-statistics")
  .get(verifyToken, loadUser, getCreditSalesGrandTotalSalesForYear);
router.route("/download-sales-csv").get(downloadSales);

router.get(
  "/products/top-by-quantity",
  verifyToken,
  loadUser,
  getTopProductsByQuantity
);
router.get(
  "/products/top-by-amount",
  verifyToken,
  loadUser,
  getTopProductsByAmount
);
// OR
router.get("/products/top", verifyToken, loadUser, getTopProducts);
module.exports = router;
