const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  createCompanyDetails,
  getCompanyDetails,
  uploadLogo,
  resizeLogo,
  createOutofstockLimit,
  getOutofstocklimit,
  createOutofstockIntervals,
  getOutofstockIntervals,
  createExchangeRates,
  getExchangeRates,
  getDeletionFrequency,
  createDeletionFrequency,
} = require("../controllers/settingsController");

const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/settings/company")
  .post(verifyToken, loadUser, uploadLogo, resizeLogo, createCompanyDetails);
router.route("/settings/:company").get(verifyToken, getCompanyDetails);
router
  .route("/stocklimit/outofstocklimit")
  .post(verifyToken, loadUser, createOutofstockLimit);
router
  .route("/stocklimit/:outofstocklimit")
  .get(verifyToken, loadUser, getOutofstocklimit);
router
  .route("/stockintervalslimit/stockintervals")
  .post(verifyToken, loadUser, createOutofstockIntervals);
router
  .route("/stockintervalslimit/:stockintervals")
  .get(verifyToken, loadUser, getOutofstockIntervals);

router
  .route("/settings/createexchangerates")
  .post(verifyToken, loadUser, createExchangeRates);
router
  .route("/settings/exchangerates/:exchangerates")
  .get(verifyToken, loadUser, getExchangeRates);
router
  .route("/settings/deletionfrequency")
  .post(verifyToken, loadUser, createDeletionFrequency);
router
  .route("/settings/deletionfrequency/:deletionfrequency")
  .get(verifyToken, loadUser, getDeletionFrequency);

module.exports = router;
