const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const { createShops, getShops } = require("../controllers/shopsController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/shops")
  .post(verifyToken, loadUser, createShops)
  .get(verifyToken, loadUser, getShops);

module.exports = router;
