const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  createStokeTake,
  getStokeTakeByDate,
  updateStokeTake,
  deleteProductInStoke,
  updateStokeTakeProductDateTime,
  updateInvoiceStokeTakeDate,
  getAllStokeTake,
  getStokeTakeReport,
  getAllUniqueStockTakeTimes,
} = require("../controllers/stokeTakeController");
const { verifyToken } = require("../middlewares/authMiddleware");

router.route("/stoketake").post(verifyToken, loadUser, createStokeTake);

router
  .route("/stoke-take-report/bydate")
  .get(verifyToken, loadUser, getStokeTakeByDate);
router.route("/stoke-takedate").get(verifyToken, loadUser, getStokeTakeReport);
router
  .route("/uniquestocktaketimes")
  .get(verifyToken, loadUser, getAllUniqueStockTakeTimes);

router
  .route("/stoketake/update/:productId")
  .put(verifyToken, loadUser, updateStokeTake);
router
  .route("/stoketake/update/product-date-time")
  .post(verifyToken, loadUser, updateStokeTakeProductDateTime);

router
  .route("/stoketakes/:stokeId/products/:productId")
  .delete(verifyToken, loadUser, deleteProductInStoke);

router
  .route("/stocktake/update-date/invoice/:id")
  .post(updateInvoiceStokeTakeDate);

module.exports = router;
