const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  createSuppliers,
  getAllSuppliers,
  updateSuppliers,
  getSingleSuppliers,
  deleteSuppliers,
  supplierProducts,
  updateStartingBalance,
  getStartingBalance,
  createOrUpdateStartingBalance,
  repayStartingBalance,
  updateStartingBalanceHistory,
  getStartingBalanceHistories,
  getGrandTotalOwnBySupplier,
} = require("../controllers/suppliersController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/suppliers")
  .post(verifyToken, loadUser, createSuppliers)
  .get(verifyToken, loadUser, getAllSuppliers);

router
  .route("/suppliers/:slug")
  .put(verifyToken, loadUser, updateSuppliers)
  .get(verifyToken, loadUser, getSingleSuppliers);
router.route("/suppliers/:id").delete(verifyToken, loadUser, deleteSuppliers);
router
  .route("/supplier/products/:id")
  .get(verifyToken, loadUser, supplierProducts);
router
  .route("/supplier/starting-balance")
  .post(verifyToken, loadUser, createOrUpdateStartingBalance);
router
  .route("/supplier/:supplierId/starting-balance")
  .put(verifyToken, loadUser, updateStartingBalance);
router
  .route("/suppliers/:id/starting-balances")
  .get(verifyToken, loadUser, getStartingBalance);
router
  .route("/repay/starting-balance")
  .post(verifyToken, loadUser, repayStartingBalance);
router
  .route("/:startingBalanceId/histories")
  .get(verifyToken, loadUser, getStartingBalanceHistories);
router
  .route("/history/:historyId")
  .post(verifyToken, loadUser, updateStartingBalanceHistory);
router
  .route("/grandtotal/balanceown/:supplierId")
  .get(verifyToken, loadUser, getGrandTotalOwnBySupplier);

module.exports = router;
