const router = require("express").Router();

const { loadUser } = require("../controllers/generalController");
const {
  getDataByDateRange,
  updateTallyCard,
  deleteTallyCard,
} = require("../controllers/tallycardController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/tallycard/:productId")
  .get(verifyToken, loadUser, getDataByDateRange);
router
  .route("/update/tallycard/:id")
  .put(verifyToken, loadUser, updateTallyCard);
router
  .route("/delete/tallycard/:id")
  .delete(verifyToken, loadUser, deleteTallyCard);

module.exports = router;
