const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  getTransfer,
  createTransfer,
  removeProductInTrans,
  removeTransfer,
  updateTransferDate,
  updateTransferQuantity,
} = require("../controllers/transferController");
const { verifyToken } = require("../middlewares/authMiddleware");

router.route("/transfers").post(verifyToken, loadUser, createTransfer);
router.route("/transfers/:shopId").get(verifyToken, loadUser, getTransfer);
router.route("/transfers/:id").delete(verifyToken, loadUser, removeTransfer);
router
  .route("/transfer/:transferId/:productId")
  .post(verifyToken, loadUser, removeProductInTrans);

router.route("/transfer/update-date/invoice/:id").put(updateTransferDate);

router
  .route("/transfer/:transferId/product/:productId/count")
  .put(verifyToken, loadUser, updateTransferQuantity);

module.exports = router;
