const router = require("express").Router();

const { loadUser } = require("../controllers/generalController");
const {
  makeUserAdmin,
  removeAsAdmin,
  trashAndUnTrashUser,
  getAllUsers,
  removeUser,
  readSingleUser,
  addUser,
  regenerateUserPassword,
  promoteUser,
  isActiveCombineRoute,
} = require("../controllers/userController");

const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/users")
  .post(verifyToken, loadUser, addUser)
  .get(verifyToken, loadUser, getAllUsers);

router.route("/makeuseradmin/:id").put(verifyToken, loadUser, makeUserAdmin);
router
  .route("/regenerate/user-password/:id")
  .put(verifyToken, loadUser, regenerateUserPassword);

router.route("/removeasadmin/:id").patch(verifyToken, loadUser, removeAsAdmin);
router
  .route("/promote/user-role/:userId/:userRole")
  .patch(verifyToken, loadUser, promoteUser);
router
  .route("/moveusertotrash/:username")
  .put(verifyToken, loadUser, trashAndUnTrashUser);
router.route("/user/refresh").put(verifyToken, loadUser, isActiveCombineRoute);

router
  .route("/user/:userId")
  .delete(verifyToken, loadUser, removeUser)
  .get(verifyToken, loadUser, readSingleUser);

module.exports = router;
