const mongoose = require("mongoose");
const bcrypt = require("bcrypt");
const Role = require("../models/roleModel");
const Route = require("../models/routeModel");
const User = require("../models/userModel");

const seedRoutes = async () => {
  const routes = [
    { path: "/admin/dashboard", name: "Admin Dashboard" },
    { path: "/seller/dashboard", name: "Seller Dashboard" },
    { path: "/auditor/dashboard", name: "Auditor Dashboard" },
    { path: "/admin/create-role", name: "Create Role" },
    { path: "/admin/assign-role", name: "Assign Role" },
  ];

  for (const route of routes) {
    try {
      const existingRoute = await Route.findOne({ path: route.path });
      if (!existingRoute) {
        await Route.create(route);
        console.log(`Route ${route.name} seeded`);
      } else {
        console.log(`Route ${route.name} already exists`);
      }
    } catch (err) {
      console.error(`Error checking/creating route ${route.name}:`, err);
    }
  }
};

const seedAdminRole = async () => {
  try {
    const existingRole = await Role.findOne({ name: "admin" });
    if (existingRole) {
      console.log("Admin role already exists");
      return existingRole;
    }
    const allRoutes = await Route.find().select("_id");
    const adminRole = new Role({ name: "admin", routes: allRoutes });
    await adminRole.save();
    console.log("Admin role seeded");
    return adminRole;
  } catch (err) {
    console.error("Error seeding admin role:", err);
  }
};

const seedAdminUser = async (adminRole) => {
  const password = "admin123@";
  const salt = await bcrypt.genSalt(10);
  const hashPassword = await bcrypt.hash(password, salt);
  try {
    const existingUser = await User.findOne({ username: "admin" });
    if (existingUser) {
      // Merge existing routes with new routes and remove duplicates
      const newRoutes = [
        ...new Set([...existingUser.assignedRoutes, ...adminRole.routes]),
      ];
      await User.findOneAndUpdate(
        {
          username: "admin",
        },
        {
          assignedRoutes: newRoutes,
        },
        {
          new: true,
        }
      );
      console.log("adminUser updated");
      return;
    }
    const adminUser = new User({
      username: "admin",
      password: hashPassword, // Make sure to hash the password in a real application
      role: adminRole._id,
      assignedRoutes: adminRole.routes,
    });
    await adminUser.save();
    console.log("Admin user seeded");
  } catch (err) {
    console.error("Error seeding admin user:", err);
  }
};

exports.seedRun = async () => {
  // await mongoose.connect(process.env.MONGO_URL, {
  //   useNewUrlParser: true,
  //   useUnifiedTopology: true,
  // });

  try {
    await seedRoutes();
    const adminRole = await seedAdminRole();
    await seedAdminUser(adminRole);
  } catch (err) {
    console.error("Error in seeding process:", err);
  } finally {
    // await mongoose.disconnect();
  }
};

// seedRun().catch((err) => console.error("Seeding error:", err));
