// const transporter = nodemailer.createTransport({
//   host: "smtp-relay.brevo.com",
//   port: 587,
//   secure: false, // true for 465, false for other ports
//   auth: {
//     user: process.env.EMAIL_USER, // your Brevo email
//     pass: process.env.EMAIL_PASSWORD, // your Brevo SMTP key
//   },
// });

// exports.sendEmailNotification = async (userId, mailOptions) => {
//   try {
//     const user = await User.findById(userId);
//     if (!user) return;

//     const recipient = user.preferences?.providedEmail || user.email;
//     if (!recipient) return;

//     const options = {
//       from: `"POS System" <${process.env.EMAIL_USER}>`,
//       to: recipient,
//       subject: mailOptions.subject,
//       text: mailOptions.text,
//       html: mailOptions.html,
//     };

//     await transporter.sendMail(options);
//   } catch (error) {
//     console.error("❌ Error sending email:", error);
//   }
// };

// services/emailService.js
const nodemailer = require("nodemailer");
const UserPreferences = require("../models/userPreferencesModel");

// Create transporter with direct SMTP configuration
const transporter = nodemailer.createTransport({
  host: "mail.ctlafricaleadership.com",
  port: 465,
  secure: true,
  domain: "ctlafricaleadership.com",
  auth: {
    user: "devops@ctlafricaleadership.com",
    pass: "Gr0wthJ0urney!",
  },
});

exports.sendEmailNotification = async (userId, mailOptions) => {
  // console.log(userId);
  try {
    // Verify connection configuration
    await transporter.verify();

    const preferences = await UserPreferences.findOne({ user: userId });

    if (!preferences?.notificationPreferences?.emailEnabled) {
      console.log(`Email notifications disabled for user ${userId}`);
      return;
    }

    if (!preferences?.providedEmail) {
      console.log(`No email provided for user ${userId}`);
      return;
    }
    const emailOptions = {
      from: `noreply@ctlafricaleadership.com`,
      to: preferences.providedEmail,
      subject: mailOptions.subject,
      text: mailOptions.text,
      html: mailOptions.html || mailOptions.text, // Fallback to text if no HTML
    };

    const info = await transporter.sendMail(emailOptions);
    return info;
  } catch (error) {
    console.error("Error sending email notification:", error);
    throw error; // Rethrow for calling code to handle
  }
};
