// utils/csvGenerator.js
function generateSalesCSV(salesData) {
  // CSV headers
  let csv = "Invoice ID,Date,Time,Total Amount,Payment Method,Items\n";

  // Add each sale as a row
  salesData.forEach((sale) => {
    const date = new Date(sale.dateTime);
    const dateStr = date.toLocaleDateString();
    const timeStr = date.toLocaleTimeString([], {
      hour: "2-digit",
      minute: "2-digit",
    });

    // Format products list
    const products = sale.products
      .map((p) => `${p.name} (${p.quantity} × GHS${p.sellingPrice})`)
      .join("; ");

    // Add row to CSV
    csv +=
      `"${sale.invoiceID}","${dateStr}","${timeStr}"` +
      `"GHS ${sale.grandTotal.toFixed(2)}","${sale.paymentMethod}",` +
      `"${products}"\n`;
  });

  return csv;
}

module.exports = { generateSalesCSV };
