// utils/emailTemplates.js
exports.productExpiryTemplate = (product) => ({
  subject: `⚠️ Product Expiry Alert: ${product.name}`,
  text: `Product ${product.name} is expiring soon on ${new Date(
    product.expireDate
  ).toLocaleDateString()}`,
  html: `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; border: 1px solid #e1e1e1; border-radius: 8px; overflow: hidden;">
        <div style="background-color: #ff9800; color: white; padding: 16px; text-align: center;">
          <h2 style="margin: 0;">Product Expiry Alert</h2>
        </div>
        <div style="padding: 20px; background-color: #fff9e6;">
          <div style="background: white; border-radius: 6px; padding: 16px; margin-bottom: 16px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
            <h3 style="margin-top: 0; color: #333;">${product.name}</h3>
            <p style="color: #d32f2f; font-weight: bold;">
              ⚠️ Expiring on: ${new Date(
                product.expireDate
              ).toLocaleDateString()}
            </p>
            <p style="color: #555;">Current Stock: <strong>${
              product.quantity
            }</strong></p>
          </div>
          <p style="text-align: center; color: #666; font-size: 14px;">
            Please take necessary action before the expiry date.
          </p>
        </div>
      </div>
    `,
});

exports.newSaleNotification = (sale) => ({
  subject: "💰 New Sale Notification",
  text: `A new sale was recorded for GHS ${sale.grandTotal.toFixed(2)}`,
  html: `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; border: 1px solid #e1e1e1; border-radius: 8px; overflow: hidden;">
        <div style="background-color: #4CAF50; color: white; padding: 16px; text-align: center;">
          <h2 style="margin: 0;">New Sale Recorded</h2>
        </div>
        <div style="padding: 20px; background-color: #f0f9f0;">
          <div style="background: white; border-radius: 6px; padding: 20px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
            <p style="font-size: 24px; margin: 0; color: #2E7D32;">GHS ${sale.grandTotal.toFixed(
              2
            )}</p>
            <p style="color: #666;">New sale completed successfully</p>
          </div>
          <p style="text-align: center; margin-top: 16px; color: #666; font-size: 14px;">
            ${new Date().toLocaleDateString()} • ${new Date().toLocaleTimeString()}
          </p>
        </div>
      </div>
    `,
});

exports.productExpiryAlert = (product, expiryDate) => {
  const descriptionHtml = product?.description
    ? `<p style="color: #555;">${product.description}</p>`
    : "";

  return {
    subject: `⚠️ Expiry Alert`,
    text: `Product ${product.name} is expiring on ${expiryDate}`,
    html: `
        <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; border: 1px solid #e1e1e1; border-radius: 8px; overflow: hidden;">
          <div style="background-color: #ff9800; color: white; padding: 16px; text-align: center;">
            <h2 style="margin: 0;">Product Expired</h2>
          </div>
          <div style="padding: 20px; background-color: #fff9e6;">
            <div style="background: white; border-radius: 6px; padding: 16px; margin-bottom: 16px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
              <h3 style="margin-top: 0; color: #333;">${product.name}</h3>
              <p style="color: #d32f2f; font-weight: bold;">
                ⏳ Expiry Date: ${expiryDate}
              </p>             
              ${descriptionHtml}
            </div>
            <p style="text-align: center; color: #666; font-size: 14px;">
              Please review this product before it expires.
            </p>
          </div>
        </div>
      `,
  };
};
exports.productSoonExpiryAlert = (product, expiryDate) => {
  const descriptionHtml = product?.description
    ? `<p style="color: #555;">${product.description}</p>`
    : "";

  return {
    subject: `⚠️ Product Expiry Alert: ${product.name}`,
    text: `Product ${product.name} is expiring on ${expiryDate}`,
    html: `
        <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; border: 1px solid #e1e1e1; border-radius: 8px; overflow: hidden;">
          <div style="background-color: #ff9800; color: white; padding: 16px; text-align: center;">
            <h2 style="margin: 0;">Product Expiring Soon</h2>
          </div>
          <div style="padding: 20px; background-color: #fff9e6;">
            <div style="background: white; border-radius: 6px; padding: 16px; margin-bottom: 16px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
              <h3 style="margin-top: 0; color: #333;">${product.name}</h3>
              <p style="color: #d32f2f; font-weight: bold;">
                ⏳ Expiry Date: ${expiryDate}
              </p>             
              ${descriptionHtml}
            </div>
            <p style="text-align: center; color: #666; font-size: 14px;">
              Please review this product before it expires.
            </p>
          </div>
        </div>
      `,
  };
};

exports.outOfStockAlert = (product) => {
  const descriptionHtml = product.description
    ? `<p style="color: #555;">${product.description}</p>`
    : "";

  const restockHtml = product.restockDate
    ? `<p style="color: #1976D2;">🔄 Restock expected: ${new Date(
        product.restockDate
      ).toLocaleDateString()}</p>`
    : "";

  return {
    subject: `🛑 Out of Stock Alert: ${product.name}`,
    text: `Product ${product.name} is now out of stock.`,
    html: `
        <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; border: 1px solid #e1e1e1; border-radius: 8px; overflow: hidden;">
          <div style="background-color: #f44336; color: white; padding: 16px; text-align: center;">
            <h2 style="margin: 0;">Out of Stock Alert</h2>
          </div>
          <div style="padding: 20px; background-color: #ffebee;">
            <div style="background: white; border-radius: 6px; padding: 16px; margin-bottom: 16px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
              <h3 style="margin-top: 0; color: #333;">${product.name}</h3>
              <p style="color: #f44336; font-weight: bold;">
                🚫 Currently out of stock
              </p>
             
              <p style="color: #555;">Current stock level: <strong>${
                product.stockQuantity || 0
              }</strong></p>
              ${descriptionHtml}
              ${restockHtml}
            </div>
            <p style="text-align: center; color: #666; font-size: 14px;">
              Please consider restocking this product.
            </p>
          </div>
        </div>
      `,
  };
};

exports.dailySalesSummary = (salesData) => {
  const totalAmount = salesData.reduce((sum, sale) => sum + sale.grandTotal, 0);
  const totalCost = salesData.reduce((sum, sale) => {
    return (
      sum +
      sale.products.reduce((pSum, p) => pSum + p.costPrice * (p.count || 0), 0)
    );
  }, 0);

  const grossProfit = totalAmount - totalCost;
  const netProfit = grossProfit; // Assuming expenses are not included
  const profitMargin = totalAmount
    ? ((netProfit / totalAmount) * 100).toFixed(2)
    : "0.00";

  return {
    subject: `📊 Daily Sales Report: ${
      salesData.length
    } sales totaling GHS ${totalAmount.toFixed(2)}`,
    html: `
    <div style="font-family: Arial, sans-serif; max-width: 720px; margin: auto; background: #fff; border-radius: 10px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.08);">
      <header style="background: #2e49a7; color: white; padding: 25px; text-align: center;">
        <h1 style="margin: 0;">📊 DAILY SALES SUMMARY</h1>
        <p>${new Date().toLocaleDateString("en-US", {
          weekday: "long",
          year: "numeric",
          month: "long",
          day: "numeric",
        })}</p>
      </header>

      <section style="padding: 20px; background: #f9fafb;">
        <div style="display: flex; flex-wrap: wrap; gap: 15px; justify-content: space-between;">
          <div style="flex: 1; background: #fff; padding: 16px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); text-align: center;">
            <p style="margin: 0; color: #555;">Total Sales</p>
            <h2 style="margin: 4px 0; color: #4a6bdf;">${salesData.length}</h2>
          </div>

          <div style="flex: 1; background: #fff; padding: 16px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); text-align: center;">
            <p style="margin: 0; color: #555;">Total Revenue</p>
            <h2 style="margin: 4px 0; color: #10b981;">GHS ${totalAmount.toFixed(
              2
            )}</h2>
          </div>

          <div style="flex: 1; background: #fff; padding: 16px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); text-align: center;">
            <p style="margin: 0; color: #555;">Gross Profit</p>
            <h2 style="margin: 4px 0; color: #3b82f6;">GHS ${grossProfit.toFixed(
              2
            )}</h2>
          </div>

          <div style="flex: 1; background: #fff; padding: 16px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); text-align: center;">
            <p style="margin: 0; color: #555;">Net Profit</p>
            <h2 style="margin: 4px 0; color: #f97316;">GHS ${netProfit.toFixed(
              2
            )}</h2>
          </div>

          <div style="flex: 1; background: #fff; padding: 16px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); text-align: center;">
            <p style="margin: 0; color: #555;">Profit Margin</p>
            <h2 style="margin: 4px 0; color: #6366f1;">${profitMargin}%</h2>
          </div>
        </div>

        <p style="margin-top: 20px; color: #64748b; font-size: 13px; text-align: center;">
          Note: Expenses are not yet included in this report.
        </p>
      </section>

      <section style="padding: 20px;">
        <h3 style="margin-bottom: 10px; color: #334155;">Sales Breakdown</h3>
        <table style="width: 100%; border-collapse: collapse;">
          <thead>
            <tr style="background-color: #f1f5f9;">
              <th style="padding: 10px; text-align: left; font-size: 13px; color: #64748b;">Invoice</th>
              <th style="padding: 10px; text-align: right; font-size: 13px; color: #64748b;">Amount</th>
              <th style="padding: 10px; text-align: right; font-size: 13px; color: #64748b;">Items</th>
              <th style="padding: 10px; text-align: right; font-size: 13px; color: #64748b;">Time</th>
            </tr>
          </thead>
          <tbody>
            ${salesData
              .map(
                (sale) => `
              <tr style="border-bottom: 1px solid #f1f5f9;">
                <td style="padding: 10px; font-size: 14px;">#${
                  sale.invoiceID
                }</td>
                <td style="padding: 10px; text-align: right; color: #10b981;">GHS ${sale.grandTotal.toFixed(
                  2
                )}</td>
                <td style="padding: 10px; text-align: right;">${
                  sale.products.length
                }</td>
                <td style="padding: 10px; text-align: right;">${new Date(
                  sale.dateTime
                ).toLocaleTimeString([], {
                  hour: "2-digit",
                  minute: "2-digit",
                })}</td>
              </tr>
            `
              )
              .join("")}
          </tbody>
        </table>
      </section>

      <footer style="background: #f1f5f9; padding: 15px; text-align: center; font-size: 12px; color: #64748b;">
        <p>Generated at ${new Date().toLocaleTimeString()}</p>
        <p>
          <a href="https://powersales.gracebusinessservices.co.uk/reports/saleshistory" 
             style="color: #4a6bdf; text-decoration: none;">
            View Full Report
          </a>
        </p>
      </footer>
    </div>
    `,
  };
};

exports.salaryPaymentReminderTemplate = (data) => {
  const formatTimeToAMPM = (timeString) => {
    const [hours, minutes] = timeString.split(":").map(Number);
    const period = hours >= 12 ? "PM" : "AM";
    const hours12 = hours % 12 || 12;
    return `${hours12}:${minutes.toString().padStart(2, "0")} ${period}`;
  };

  const { reminderDate, reminderTime, companyName = "Our Company" } = data;
  const formattedTime = formatTimeToAMPM(reminderTime);

  return {
    subject: `💰 Salary Payment Reminder - ${reminderDate}th of the Month`,
    text: `
      Dear Admin,
      
      This is a reminder to process salary payments for all employees today (${reminderDate}th).
      
      Reminder Time: ${formattedTime}
      Company: ${companyName}
      
      Please ensure all salary payments are processed before the end of the day.
      
      Best regards,
      ${companyName} HR System
    `,
    html: `
      <!DOCTYPE html>
      <html>
      <head>
        <meta charset="UTF-8" />
        <title>Salary Reminder</title>
      </head>
      <body style="margin:0; padding:0; font-family: Arial, sans-serif; background-color:#f4f4f4;">
        <div style="max-width:600px; margin:0 auto; background:#ffffff; border-radius:8px; overflow:hidden; box-shadow:0 0 10px rgba(0,0,0,0.1);">
          <div style="background-color:#4CAF50; padding:20px; text-align:center; color:#ffffff;">
            <h2 style="margin:0;">Salary Payment Reminder</h2>
          </div>
          <div style="padding:30px;">
            <p style="font-size:16px; color:#333;">Dear Admin,</p>
            <div style="background:#f1f1f1; padding:15px; border-left:5px solid #4CAF50; margin:20px 0; border-radius:4px;">
              <p style="margin:0; font-size:15px; color:#333;">
                This is a reminder to process salary payments for all employees today (<strong>${reminderDate}th</strong> of the month).
              </p>
              <p style="margin:10px 0 0;"><strong>Scheduled Time:</strong> ${formattedTime}</p>
            </div>
            <p style="font-size:15px;">Please ensure all salary payments are processed before the end of the day.</p>

            <a href="https://powersales.gracebusinessservices.co.uk/salaries"
               style="display:inline-block; padding:12px 20px; background-color:#4CAF50; color:#ffffff; text-decoration:none; font-weight:bold; border-radius:5px; font-size:16px; margin:10px 0;">
              Process Salaries Now
            </a>

            <p style="font-size:14px; color:#555;">If you've already processed salaries, please ignore this reminder.</p>
          </div>
          <div style="background-color:#f9f9f9; padding:15px; text-align:center; font-size:12px; color:#999;">
            <p style="margin:5px 0;">${companyName} HR System</p>
            <p style="margin:5px 0;">This is an automated message. Please do not reply.</p>
          </div>
        </div>
      </body>
      </html>
    `,
  };
};

function getProductColor(index) {
  const colors = ["#4a6bdf", "#10b981", "#f59e0b"];
  return colors[index] || "#4a6bdf";
}

// Helper function to get performance rating
function getPerformanceRating(salesCount) {
  if (salesCount >= 8) return "Excellent 🎉";
  if (salesCount >= 5) return "Good 👍";
  if (salesCount >= 3) return "Average 👌";
  return "Needs Improvement 💪";
}

// Helper function to get top selling products
function getTopProducts(salesData) {
  const productMap = {};

  salesData.forEach((sale) => {
    sale.products.forEach((product) => {
      if (!productMap[product.name]) {
        productMap[product.name] = {
          name: product.name,
          totalSold: 0,
          totalRevenue: 0,
        };
      }
      productMap[product.name].totalSold += product.quantity;
      productMap[product.name].totalRevenue +=
        product.quantity * product.sellingPrice;
    });
  });

  return Object.values(productMap).sort((a, b) => b.totalSold - a.totalSold);
}
